# Yii2 React Calendar Widget

Yii2 widget for react-calendar component.

## Installation

```bash
composer require garmayev/yii2-calendar
```

## Usage
### Basic usage
```php
use garmayev\calendar\ReactCalendarWidget;

echo ReactCalendarWidget::widget([
    'clientOptions' => [
    'onChange' => new \yii\web\JsExpression('
        function(value) {
            console.log("Selected date:", value);
        }'),
    ],
]);
```

### With form input

```php
echo ReactCalendarWidget::widget([
    'enableFormInput' => true,
    'inputName' => 'date',
    'value' => '2024-01-15',
    'clientOptions' => [
        'locale' => 'ru-RU',
        'selectRange' => true,
    ],
]);
```

### All available options

```php
echo ReactCalendarWidget::widget([
    'clientOptions' => [
        'value' => new \yii\web\JsExpression('new Date()'),
        'minDate' => new \yii\web\JsExpression('new Date(2020, 0, 1)'),
        'maxDate' => new \yii\web\JsExpression('new Date(2025, 11, 31)'),
        'selectRange' => true,
        'showDoubleView' => true,
        'tileClassName' => new \yii\web\JsExpression('({ date }) => date.getDay() === 0 ? "sunday" : null'),
    ],
]);