<?php

namespace garmayev\calendar\assets;

use yii\web\AssetBundle;

class CalendarAsset extends AssetBundle
{
    public $sourcePath = null;
    public $css = [];
    public $js = [];
    public $depends = [];

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();

        // Определяем пути в зависимости от окружения
        $this->js = [
            \Yii::getAlias('@npm/react/umd/react.production.min.js'),
            \Yii::getAlias('@npm/react-dom/umd/react-dom.production.min.js'),
            \Yii::getAlias('@npm/react-calendar/dist/umd/Calendar.min.js'),
        ];
        $this->css = [
            \Yii::getAlias('@npm/react-calendar/dist/Calendar.css'),
        ];

        // Добавляем скрипт инициализации
        $initScript = 'react-calendar-init.min.js';

        $this->js[] = $this->publishAsset($initScript);
    }

    /**
     * Публикует файл ассета из директории расширения
     */
    protected function publishAsset($file)
    {
        $assetPath = dirname(__DIR__) . '/assets/js/' . $file;

        // Если файл не существует, используем исходную версию
        if (!file_exists($assetPath) && strpos($file, '.min.js') !== false) {
            $file = str_replace('.min.js', '.js', $file);
            $assetPath = dirname(__DIR__) . '/assets/js/' . $file;
        }

        if (file_exists($assetPath)) {
            $published = \Yii::$app->assetManager->publish($assetPath);
            return $published[1];
        }

        return null;
    }
}