/**
 * React Calendar initialization
 */
(function() {
    // Make Calendar available globally
    if (typeof ReactCalendar !== 'undefined') {
        window.Calendar = ReactCalendar.default || ReactCalendar;
    }

    // Add default styles if not present
    if (!document.querySelector('style[data-react-calendar]')) {
        const style = document.createElement('style');
        style.setAttribute('data-react-calendar', '');
        style.textContent = `
            .react-calendar__tile--active {
                background: #006edc;
                color: white;
            }
            .react-calendar__tile--now {
                background: #ffff76;
            }
        `;
        document.head.appendChild(style);
    }
})();