<?php
namespace garmayev\telegram\base;

/**
 * Трейт для работы с callback-данными
 */
trait CallbackDataTrait
{
    /**
     * Разбор callback data на команду и параметры
     * @param string $callbackData
     * @return array
     */
    public static function parseCallbackData($callbackData)
    {
        $parts = explode(':', $callbackData);
        $command = array_shift($parts);
        $params = $parts;

        return [
            'command' => $command,
            'params' => $params
        ];
    }

    /**
     * Создание callback data из команды и параметров
     * @param string $command
     * @param array $params
     * @return string
     */
    public static function buildCallbackData($command, $params = [])
    {
        $data = $command;
        if (!empty($params)) {
            $data .= ':' . implode(':', $params);
        }

        // Ограничение Telegram - 64 байта
        if (strlen($data) > 64) {
            throw new \InvalidArgumentException("Callback data exceeds 64 bytes limit");
        }

        return $data;
    }
}