<?php
namespace garmayev\telegram\base;

/**
 * Интерфейс для обработчиков callback-запросов от инлайновых кнопок
 */
interface CallbackHandlerInterface
{
    /**
     * Возвращает callback data, который обрабатывает этот класс
     * Может быть строкой или регулярным выражением
     * @return string
     */
    public static function getCallbackData();

    /**
     * Обработка callback-запроса
     * @param object $telegram объект Telegram API
     * @param object $callbackQuery объект callback_query
     * @param array $params дополнительные параметры из callback data
     * @return mixed
     */
    public function handleCallback($telegram, $callbackQuery, $params = []);
}