<?php
namespace garmayev\telegram\base;

/**
 * Интерфейс для обработчиков контента Telegram бота
 */
interface ContentHandlerInterface
{
    /**
     * Возвращает тип контента, который обрабатывает этот класс
     * @return string
     */
    public static function getContentType();

    /**
     * Обработка контента
     * @param object $telegram объект Telegram API
     * @param mixed $contentData данные контента
     * @param bool $isCallback является ли вызов callback'ом от инлайн-кнопки
     * @param object|null $callbackQuery объект callback_query (если есть)
     * @return mixed
     */
    public function handle($telegram, $contentData, $isCallback, $callbackQuery = null);
}