# Документация по методам Telegram Bot API
## Содержание
[Базовые методы](#base "Базовые методы")

[Методы для отправки сообщений](#messages "Методы для отправки сообщений")

[Методы для редактирования сообщений](#edit "Методы для редактирования сообщений")

[Методы для работы с чатами](#chats "Методы для работы с чатами")

[Методы для администраторов](#admin "Методы для администраторов")

[Методы для игр](#games "Методы для игр")

[Методы для файлов](#files "Методы для файлов")

[Методы для вебхука](#webhook "Методы для вебхука")

[Методы для команд бота](#bot "Методы для команд бота")

# [Базовые методы](#base)
### getMe
__Описание__: *Получение информации о боте*

__Параметры__: *Нет*

#### Пример:

```php
$response = Yii::$app->telegram->getMe();
if ($response->ok) {
    $botUsername = $response->result['user']['username'];
    echo "Бот: @{$botUsername}";
}
```

__Возвращает__: *Объект с информацией о боте*

###

### getUpdates
    Описание: Получение обновлений (сообщений) через long polling
    Параметры:
        offset (int) - Идентификатор первого обновления
        limit (int) - Лимит обновлений (1-100)
        timeout (int) - Таймаут в секундах

__Пример__:

```php
$updates = Yii::$app->telegram->getUpdates([
    'offset' => 123456,
    'limit' => 10,
    'timeout' => 30
]);
```

# [Методы для отправки сообщений](#messages)

### sendMessage

    Описание: Отправка текстового сообщения
    Параметры:
        chat_id (int/string) - ID чата или username
        text (string) - Текст сообщения
        parse_mode (string) - Форматирование (Markdown, HTML)
        reply_markup (string) - Клавиатура (JSON)
        reply_to_message_id (int) - ID сообщения для ответа
        disable_web_page_preview (bool) - Отключить превью ссылок

#### Пример:

```php
$response = Yii::$app->telegram->sendMessage([
    'chat_id' => 123456789,
    'text' => 'Привет, мир! 👋',
    'parse_mode' => 'HTML',
    'reply_markup' => json_encode([
        'inline_keyboard' => [
            [['text' => 'Кнопка 1', 'callback_data' => 'btn1']],
            [['text' => 'Кнопка 2', 'url' => 'https://example.com']]
        ]
    ])
]);
```

### sendPhoto
    Описание: Отправка фотографии
    Параметры:
        chat_id (int/string) - ID чата
        photo (string) - Путь к файлу или file_id
        caption (string) - Подпись к фото
        parse_mode (string) - Форматирование подписи

#### Пример:

```php
$response = Yii::$app->telegram->sendPhoto([
    'chat_id' => 123456789,
    'photo' => '/path/to/photo.jpg',
    'caption' => 'Мое фото 📸',
    'parse_mode' => 'Markdown'
]);
```

### sendDocument
    Описание: Отправка документа
    Параметры:
        chat_id (int/string) - ID чата
        document (string) - Путь к файлу или file_id
        caption (string) - Подпись к документу
        thumb (string) - Превью (для анимаций)

#### Пример:

```php
$response = Yii::$app->telegram->sendDocument([
    'chat_id' => 123456789,
    'document' => '/path/to/document.pdf',
    'caption' => 'Ваш документ 📄'
]);
```

### sendVideo
    Описание: Отправка видео
    Параметры:
        chat_id (int/string) - ID чата
        video (string) - Путь к файлу или file_id
        duration (int) - Длительность в секундах
        width (int) - Ширина видео
        height (int) - Высота видео
        caption (string) - Подпись к видео

#### Пример:

```php
$response = Yii::$app->telegram->sendVideo([
    'chat_id' => 123456789,
    'video' => '/path/to/video.mp4',
    'duration' => 60,
    'caption' => 'Мое видео 🎥'
]);
```

### sendAudio
    Описание: Отправка аудиофайла
    Параметры:
        chat_id (int/string) - ID чата
        audio (string) - Путь к файлу или file_id
        duration (int) - Длительность в секундах
        performer (string) - Исполнитель
        title (string) - Название трека

#### Пример:

```php
$response = Yii::$app->telegram->sendAudio([
    'chat_id' => 123456789,
    'audio' => '/path/to/audio.mp3',
    'title' => 'Моя песня',
    'performer' => 'Я'
]);
```

### sendVoice
    Описание: Отправка голосового сообщения
    Параметры:
        chat_id (int/string) - ID чата
        voice (string) - Путь к файлу или file_id
        duration (int) - Длительность в секундах
        caption (string) - Подпись

#### Пример:

```php
$response = Yii::$app->telegram->sendVoice([
    'chat_id' => 123456789,
    'voice' => '/path/to/voice.ogg',
    'duration' => 30
]);
```

### sendVideoNote
    Описание: Отправка видеосообщения (круглое видео)
    Параметры:
        chat_id (int/string) - ID чата
        video_note (string) - Путь к файлу или file_id
        duration (int) - Длительность в секундах
        length (int) - Диаметр видео

#### Пример:

```php
$response = Yii::$app->telegram->sendVideoNote([
    'chat_id' => 123456789,
    'video_note' => '/path/to/video_note.mp4',
    'duration' => 15
]);
```

### sendLocation
    Описание: Отправка локации
    Параметры:
        chat_id (int/string) - ID чата
        latitude (float) - Широта
        longitude (float) - Долгота
        live_period (int) - Период обновления в секундах

#### Пример:

```php
$response = Yii::$app->telegram->sendLocation([
    'chat_id' => 123456789,
    'latitude' => 55.7558,
    'longitude' => 37.6173,
    'live_period' => 3600
]);
```

### sendSticker
    Описание: Отправка стикера
    Параметры:
        chat_id (int/string) - ID чата
        sticker (string) - Путь к файлу или file_id

#### Пример:

```php
$response = Yii::$app->telegram->sendSticker([
    'chat_id' => 123456789,
    'sticker' => '/path/to/sticker.webp'
]);
```

### sendAnimation
    Описание: Отправка анимации (GIF)
    Параметры:
        chat_id (int/string) - ID чата
        animation (string) - Путь к файлу или file_id
        duration (int) - Длительность в секундах
        width (int) - Ширина
        height (int) - Высота
        thumb (string) - Превью

#### Пример:

```php
$response = Yii::$app->telegram->sendAnimation([
    'chat_id' => 123456789,
    'animation' => '/path/to/animation.gif',
    'duration' => 5
]);
```

### sendMediaGroup
    Описание: Отправка группы медиафайлов
    Параметры:
        chat_id (int/string) - ID чата
        media (array) - Массив медиаобъектов

#### Пример:

```php
$response = Yii::$app->telegram->sendMediaGroup([
    'chat_id' => 123456789,
    'media' => json_encode([
        ['type' => 'photo', 'media' => '/path/to/photo1.jpg'],
        ['type' => 'photo', 'media' => '/path/to/photo2.jpg'],
        ['type' => 'video', 'media' => '/path/to/video.mp4']
    ])
]);
```

### sendChatAction
    Описание: Отправка действия чата (показывает статус бота)
    Параметры:
        chat_id (int/string) - ID чата
        action (string) - Действие: typing, upload_photo, record_video, upload_video, record_voice, upload_voice, upload_document, find_location, record_video_note, upload_video_note

#### Пример:

```php
$response = Yii::$app->telegram->sendChatAction([
    'chat_id' => 123456789,
    'action' => 'typing'
]);
```

### forwardMessage
    Описание: Пересылка сообщения
    Параметры:
        chat_id (int/string) - ID чата назначения
        from_chat_id (int/string) - ID исходного чата
        message_id (int) - ID сообщения

#### Пример:

```php
$response = Yii::$app->telegram->forwardMessage([
    'chat_id' => 123456789,
    'from_chat_id' => 987654321,
    'message_id' => 123
]);
```

# [Методы для редактирования сообщений](#edit)

### editMessageText
    Описание: Редактирование текста сообщения
    Параметры:
        chat_id (int/string) - ID чата
        message_id (int) - ID сообщения
        inline_message_id (string) - ID inline сообщения
        text (string) - Новый текст
        parse_mode (string) - Форматирование
        reply_markup (string) - Новая клавиатура

#### Пример:

```php
$response = Yii::$app->telegram->editMessageText([
    'chat_id' => 123456789,
    'message_id' => 123,
    'text' => 'Обновленный текст ✏️',
    'reply_markup' => json_encode([
        'inline_keyboard' => [[['text' => 'Новая кнопка', 'callback_data' => 'new']]]
    ])
]);
```

### editMessageCaption
    Описание: Редактирование подписи к медиа
    Параметры:
        chat_id (int/string) - ID чата
        message_id (int) - ID сообщения
        inline_message_id (string) - ID inline сообщения
        caption (string) - Новая подпись

#### Пример:

```php
$response = Yii::$app->telegram->editMessageCaption([
    'chat_id' => 123456789,
    'message_id' => 123,
    'caption' => 'Новая подпись 📝'
]);
```

### editMessageLiveLocation

    Описание: Редактирование живой локации
    Параметры:
        chat_id (int/string) - ID чата
        message_id (int) - ID сообщения
        inline_message_id (string) - ID inline сообщения
        latitude (float) - Новая широта
        longitude (float) - Новая долгота

#### Пример:

```php
$response = Yii::$app->telegram->editMessageLiveLocation([
    'chat_id' => 123456789,
    'message_id' => 123,
    'latitude' => 55.7558,
    'longitude' => 37.6173
]);
```

### stopMessageLiveLocation

    Описание: Остановка живой локации
    Параметры:
        chat_id (int/string) - ID чата
        message_id (int) - ID сообщения
        inline_message_id (string) - ID inline сообщения

#### Пример:

```php
$response = Yii::$app->telegram->stopMessageLiveLocation([
    'chat_id' => 123456789,
    'message_id' => 123
]);
```

# [Методы для работы с чатами](#chats)

### getChat

    Описание: Получение информации о чате
    Параметры:
        chat_id (int/string) - ID чата или username

#### Пример:

```php
$response = Yii::$app->telegram->getChat([
    'chat_id' => 123456789
]);
if ($response->ok) {
    $chatTitle = $response->result['title'];
    echo "Чат: {$chatTitle}";
}
```

### getChatAdministrators

    Описание: Получение списка администраторов чата
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->getChatAdministrators([
    'chat_id' => 123456789
]);
if ($response->ok) {
    foreach ($response->result as $admin) {
        echo "Админ: {$admin['user']['first_name']}\n";
    }
}
```

### getChatMembersCount

    Описание: Получение количества участников чата
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->getChatMembersCount([
    'chat_id' => 123456789
]);
if ($response->ok) {
    echo "Участников: {$response->result}";
}
```

### getChatMember

    Описание: Получение информации об участнике чата
    Параметры:
        chat_id (int/string) - ID чата
        user_id (int) - ID пользователя

#### Пример:

```php
$response = Yii::$app->telegram->getChatMember([
    'chat_id' => 123456789,
    'user_id' => 987654321
]);
```

# [Методы для администраторов](#admin)

### kickChatMember

    Описание: Исключение пользователя из чата
    Параметры:
        chat_id (int/string) - ID чата
        user_id (int) - ID пользователя
        until_date (int) - Дата разбана (timestamp)

#### Пример:

```php
$response = Yii::$app->telegram->kickChatMember([
    'chat_id' => 123456789,
    'user_id' => 987654321,
    'until_date' => time() + 3600 // Забанен на 1 час
]);
```

### unbanChatMember

    Описание: Разбан пользователя
    Параметры:
        chat_id (int/string) - ID чата
        user_id (int) - ID пользователя

#### Пример:

```php
$response = Yii::$app->telegram->unbanChatMember([
    'chat_id' => 123456789,
    'user_id' => 987654321
]);
```

### restrictChatMember

    Описание: Ограничение прав пользователя
    Параметры:
        chat_id (int/string) - ID чата
        user_id (int) - ID пользователя
        permissions (array) - Права доступа

#### Пример:

```php
$response = Yii::$app->telegram->restrictChatMember([
    'chat_id' => 123456789,
    'user_id' => 987654321,
    'permissions' => json_encode([
        'can_send_messages' => false,
        'can_send_media_messages' => false
    ])
]);
```

### promoteChatMember

    Описание: Назначение администратора
    Параметры:
        chat_id (int/string) - ID чата
        user_id (int) - ID пользователя
        can_... (bool) - Разрешения

#### Пример:

```php
$response = Yii::$app->telegram->promoteChatMember([
    'chat_id' => 123456789,
    'user_id' => 987654321,
    'can_change_info' => true,
    'can_delete_messages' => true,
    'can_invite_users' => true
]);
```

### exportChatInviteLink

    Описание: Создание ссылки-приглашения
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->exportChatInviteLink([
    'chat_id' => 123456789
]);
if ($response->ok) {
    echo "Ссылка: {$response->result}";
}
```

### setChatPhoto

    Описание: Установка фото чата
    Параметры:
        chat_id (int/string) - ID чата
        photo (string) - Путь к файлу

#### Пример:

```php
$response = Yii::$app->telegram->setChatPhoto([
    'chat_id' => 123456789,
    'photo' => '/path/to/chat_photo.jpg'
]);
```

### deleteChatPhoto

    Описание: Удаление фото чата
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->deleteChatPhoto([
    'chat_id' => 123456789
]);
```

### setChatTitle

    Описание: Установка названия чата
    Параметры:
        chat_id (int/string) - ID чата
        title (string) - Новое название

#### Пример:

```php
$response = Yii::$app->telegram->setChatTitle([
    'chat_id' => 123456789,
    'title' => 'Новое название чата'
]);
```

### setChatDescription

    Описание: Установка описания чата
    Параметры:
        chat_id (int/string) - ID чата
        description (string) - Описание

#### Пример:

```php
$response = Yii::$app->telegram->setChatDescription([
    'chat_id' => 123456789,
    'description' => 'Описание нашего чата'
]);
```

### pinChatMessage

    Описание: Закрепление сообщения
    Параметры:
        chat_id (int/string) - ID чата
        message_id (int) - ID сообщения
        disable_notification (bool) - Без уведомления

#### Пример:

```php
$response = Yii::$app->telegram->pinChatMessage([
    'chat_id' => 123456789,
    'message_id' => 123,
    'disable_notification' => true
]);
```

### unpinChatMessage

    Описание: Открепление сообщения
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->unpinChatMessage([
    'chat_id' => 123456789
]);
```

### leaveChat

    Описание: Выход бота из чата
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->leaveChat([
    'chat_id' => 123456789
]);
```

# [Методы для игр](#games)

### sendGame

    Описание: Отправка игры
    Параметры:
        chat_id (int) - ID чата
        game_short_name (string) - Короткое название игры
        reply_markup (string) - Inline-клавиатура

#### Пример:

```php
$response = Yii::$app->telegram->sendGame([
    'chat_id' => 123456789,
    'game_short_name' => 'my_game'
]);
```

### setGameScore

    Описание: Установка счета в игре
    Параметры:
        user_id (int) - ID пользователя
        score (int) - Счет
        force (bool) - Принудительно
        disable_edit_message (bool) - Не редактировать сообщение
        chat_id (int) - ID чата
        message_id (int) - ID сообщения
        inline_message_id (string) - ID inline сообщения

#### Пример:

```php
$response = Yii::$app->telegram->setGameScore([
    'user_id' => 987654321,
    'score' => 1000,
    'chat_id' => 123456789,
    'message_id' => 123
]);
```

### getGameHighScores

    Описание: Получение таблицы рекордов
    Параметры:
        user_id (int) - ID пользователя
        chat_id (int) - ID чата
        message_id (int) - ID сообщения
        inline_message_id (string) - ID inline сообщения

#### Пример:

```php
$response = Yii::$app->telegram->getGameHighScores([
    'user_id' => 987654321,
    'chat_id' => 123456789,
    'message_id' => 123
]);
```

# [Методы для файлов](#files)

### getFile

    Описание: Получение информации о файле
    Параметры:
        file_id (string) - ID файла

#### Пример:

```php
$response = Yii::$app->telegram->getFile([
    'file_id' => 'AgACAgIAAxkBAAIB'
]);
```

### getFileUrl

    Описание: Получение URL для скачивания файла
    Параметры:
        file_id (string) - ID файла

#### Пример:

```php
$fileUrl = Yii::$app->telegram->getFileUrl([
    'file_id' => 'AgACAgIAAxkBAAIB'
]);
if ($fileUrl) {
    echo "URL файла: {$fileUrl}";
}
```

# [Методы для вебхука](#webhook)

### setWebhook

    Описание: Установка вебхука
    Параметры:
        url (string) - URL вебхука
        certificate (string) - Путь к сертификату
        max_connections (int) - Максимум соединений
        allowed_updates (array) - Типы обновлений

#### Пример:

```php
$response = Yii::$app->telegram->setWebhook([
    'url' => 'https://example.com/bot/webhook',
    'max_connections' => 40,
    'allowed_updates' => ['message', 'callback_query']
]);
```

### deleteWebhook

    Описание: Удаление вебхука
    Параметры: Нет

#### Пример:

```php
$response = Yii::$app->telegram->deleteWebhook();
```

# [Методы для команд бота](#bot)

### setMyCommands

    Описание: Установка списка команд бота
    Параметры:
    commands (array) - Массив команд
    scope (array) - Область видимости
    language_code (string) - Код языка

#### Пример:

```php
$response = Yii::$app->telegram->setMyCommands([
    'commands' => json_encode([
        ['command' => '/start', 'description' => 'Запустить бота'],
        ['command' => '/help', 'description' => 'Помощь'],
        ['command' => '/settings', 'description' => 'Настройки']
    ])
]);
```

# Вспомогательные методы

### answerCallbackQuery

    Описание: Ответ на callback запрос
    Параметры:
        callback_query_id (string) - ID callback запроса
        text (string) - Текст ответа
        show_alert (bool) - Показать alert
        url (string) - URL для открытия
        cache_time (int) - Время кеширования

#### Пример:

```php
$response = Yii::$app->telegram->answerCallbackQuery([
    'callback_query_id' => '123456',
    'text' => 'Обработано!',
    'show_alert' => false
]);
```

### answerInlineQuery

    Описание: Ответ на inline запрос
    Параметры:
        inline_query_id (string) - ID inline запроса
        results (array) - Результаты
        cache_time (int) - Время кеширования
        is_personal (bool) - Персональные результаты
        next_offset (string) - Следующий offset

#### Пример:

```php
$response = Yii::$app->telegram->answerInlineQuery([
    'inline_query_id' => '123456',
    'results' => json_encode([
        [
            'type' => 'article',
            'id' => '1',
            'title' => 'Результат 1',
            'input_message_content' => ['message_text' => 'Текст результата 1']
        ]
    ])
]);
```

### deleteMessage

    Описание: Удаление сообщения
    Параметры:
        chat_id (int/string) - ID чата
        message_id (int) - ID сообщения

#### Пример:

```php
$response = Yii::$app->telegram->deleteMessage([
    'chat_id' => 123456789,
    'message_id' => 123
]);
```

### getUserProfilePhotos

    Описание: Получение фото профиля пользователя
    Параметры:
        user_id (int) - ID пользователя
        offset (int) - Смещение
        limit (int) - Лимит (1-100)

#### Пример:

```php
$response = Yii::$app->telegram->getUserProfilePhotos([
    'user_id' => 987654321,
    'limit' => 10
]);
```

### setChatStickerSet

    Описание: Установка набора стикеров
    Параметры:
        chat_id (int/string) - ID чата
        sticker_set_name (string) - Название набора

#### Пример:

```php
$response = Yii::$app->telegram->setChatStickerSet([
    'chat_id' => 123456789,
    'sticker_set_name' => 'my_sticker_set'
]);
```

### deleteChatStickerSet

    Описание: Удаление набора стикеров
    Параметры:
        chat_id (int/string) - ID чата

#### Пример:

```php
$response = Yii::$app->telegram->deleteChatStickerSet([
    'chat_id' => 123456789
]);
```

# Общие замечания

- **Обязательные параметры**: *Для каждого метода указаны обязательные параметры*
- **Типы данных**: *Следите за типами передаваемых параметров*
- **JSON кодирование**: *Для параметров reply_markup, media и других сложных структур используйте json_encode()*
- **Обработка ответов**: *Все методы возвращают объект Response с полями ok и result*
- **Ошибки**: *Проверяйте $response->ok перед использованием результатов*

#### Пример обработки ответа:

```php
$response = Yii::$app->telegram->sendMessage([...]);
if ($response->ok) {
    $messageId = $response->result['message_id'];
    // Действия при успехе
} else {
    $errorCode = $response->error_code;
    $description = $response->description;
    // Обработка ошибки
}
```